<?php
/**
 * Template name: SurveyListAdmin
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package lifescore
 */

global $wpdb;

$items_per_page = 4;
$page = isset( $_GET['cpage'] ) ? abs( (int) $_GET['cpage'] ) : 1;
$offset = ( $page * $items_per_page ) - $items_per_page;

$query = 'SELECT * FROM wp_survey Inner JOIN wp_users ON wp_survey.user_id = wp_users.ID';

$total_query = "SELECT COUNT(1) FROM (${query}) AS combined_table";
$total = $wpdb->get_var( $total_query );

$result = $wpdb->get_results( $query.' ORDER BY survey_id DESC LIMIT '. $offset.', '. $items_per_page );

?>
<style type="text/css">
table.alternate tr:nth-child(odd) {
background-color : #f6f7f7 ;
}
table.alternate tr:nth-child(even) {
background-color : #ffffff ;
} 



a.page-numbers {
    color: #a7aaad!important;
    border-color: #dcdcde!important;
    background: #f6f7f7!important;
    box-shadow: none!important;
    cursor: default;
    transform: none!important;
    display: inline-block;
    vertical-align: baseline;
    min-width: 30px;
    min-height: 30px;
    margin: 0;
    padding: 0 4px;
    font-size: 16px;
    line-height: 1.625;
    text-align: center;
    border-width: 1px;
    border-style: solid;
    -webkit-appearance: none;
    border-radius: 3px;
    white-space: nowrap;
    box-sizing: border-box;
}
	
	span.page-numbers.current:hover {
		color: #a7aaad!important;
		border-color: #dcdcde!important;
		background: #f6f7f7!important;
		box-shadow: none!important;
		cursor: default;
		transform: none!important;
		display: inline-block;
		vertical-align: baseline;
		min-width: 30px;
		min-height: 30px;
		margin: 0;
		padding: 0 4px;
		font-size: 16px;
		line-height: 1.625;
		text-align: center;
		border-width: 1px;
		border-style: solid;
		-webkit-appearance: none;
		border-radius: 3px;
		white-space: nowrap;
		box-sizing: border-box;
	}



span.page-numbers.current {
    display: inline-block;
    vertical-align: baseline;
    min-width: 30px;
    min-height: 30px;
    margin: 0;
    padding: 0 4px;
    font-size: 16px;
    line-height: 1.625;
    text-align: center;
    color: #2271b1;
    border-color: #2271b1;
    background: #f6f7f7;
    vertical-align: top;
    cursor: pointer;
    border-width: 1px;
    border-style: solid;
    -webkit-appearance: none;
    border-radius: 3px;
    white-space: nowrap;
    box-sizing: border-box;
	cursor: pointer;
}

</style>
<div class="clear"></div>
	<div class="main_contant">
        <!------about_mylife-------->

        <section class="membership_life">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="membership-heading align-left ">
                            <h2> Survey Listing </h2>
                        </div>
                    </div>
                </div>

                <main class="cd__main">
					<form id="date-filter-form" method="post">
						<label for="user_dtl">Name:</label>
						<input type="text" class="input-text" name="user_dtls" id="user_dtls" value="<?php if ( ! empty( $_POST['user_dtls'] ) ) esc_attr_e( $_POST['user_dtls'] ); ?>" />&nbsp;&nbsp;
						<label for="start-date">Start Date:</label>
						<input type="date" id="start-date" name="start-date">&nbsp;&nbsp;
						<label for="end-date">End Date:</label>
						<input type="date" id="end-date" name="end-date">
						<button type="submit">Filter</button>
					</form>
                    <!-- Start DEMO HTML (Use the following code into your project)-->
					<table id="example" class="wp-list-table widefat fixed striped table-view-list posts" style="width:100%">
					   <thead>
						   <tr>
							   <th style="text-align: left;font-size:14px;">Name</th>
							   <th style="text-align: left;font-size:14px;">Date</th>
							   <th style="text-align: left;font-size:14px;">Overall Score</th>
							   <th style="text-align: left;font-size:14px;">View</th>
						   </tr>
					   </thead>
						<tbody id="filtered-posts-container">
							<?php
								$i = 1;
								foreach($result as $index => $survey){ 
									$uData = get_userdata( $survey->user_id );
									$full_name = esc_attr( $uData->first_name ) . " " . esc_attr( $uData->last_name );
									$result = $wpdb->get_results(sprintf('SELECT * FROM wp_survey WHERE survey_id=' . $survey->survey_id));
									$total_question = $result[0]->total_question * 10;


									$data = json_decode($result[0]->data);
									$cat = array();
									$chcked = array();
									$allpoint = 0;

									foreach ($data as $datas) {
										$res = explode('-', $datas);
										$cat[] = $res[0];
										$value = $res[3];
										$k = $res[0];
										$chcked[$k][] = $value;
										$allpoint = $allpoint + $value;
									}

									$percentageAll = round(($allpoint * 100 / $total_question));
									
									$survey_date = date('F j, Y', strtotime($survey->created_at));
							?>
							   <tr>
								   <td><span><?php echo $full_name; ?></span></td>
								   <td><span><?php echo $survey_date; ?></span></td>
								   <td><span><?php echo $percentageAll; ?>%</span></td>
								   <td>
									<ul class="action-table">
										<li> <a href="/result?surveyid=<?php echo $survey->survey_id ?>"> <i class="fa fa-eye" aria-hidden="true"></i> </a> </li>
									</ul>
								   </td>
							   </tr>
							<?php } ?>
							<tr style="text-align: right;"> <div class="pagination-admin"> 
								<td colspan="4">

									<?php
									echo paginate_links( array(
										'base' => add_query_arg( 'cpage', '%#%' ),
										'format' => '',
										'prev_text' => __('&laquo;'),
										'next_text' => __('&raquo;'),
										'total' => ceil($total / $items_per_page),
										'current' => $page
									));
									?>
							</td> </div>
						   </tr>

						</tbody>
					</table>
                    <!-- END EDMO HTML (Happy Coding!)-->
                 </main>


            </div>
 
        </section>

    </div><!-----main_contant-------->

<div class="clear"></div>
<script>
jQuery(document).ready(function($) {
    $('#date-filter-form').submit(function(event) {
        event.preventDefault();
        var startDate = $('#start-date').val();
        var endDate = $('#end-date').val();
		var user_dtls = $('#user_dtls').val();
        $.ajax({
            url: '<?php echo admin_url('admin-ajax.php'); ?>',
            type: 'post',
            data: {
                action: 'filter_survey_list',
				user_dtls: user_dtls,
                start_date: startDate,
                end_date: endDate
            },
            success: function(response) {
                $('#filtered-posts-container').html(response);
            },
			error: function(error) {
				$('#filtered-posts-container').html(error);
				alert(error);
			}
        });
    });
});
</script>